    using Cimbalino.Toolkit.Services;
    using GalaSoft.MvvmLight.Ioc;
    using Microsoft.Practices.ServiceLocation;

    namespace App1.ViewModel
    {
        public class ViewModelLocator
        {
            public ViewModelLocator()
            {
                ServiceLocator.SetLocatorProvider(() => SimpleIoc.Default);

                SimpleIoc.Default.Register<IMessageBoxService, MessageBoxService>();

                SimpleIoc.Default.Register<MainViewModel>();
            }

            public MainViewModel Main
            {
                get
                {
                    return ServiceLocator.Current.GetInstance<MainViewModel>();
                }
            }
        
            public static void Cleanup()
            {
                // TODO Clear the ViewModels
            }
        }
    }