using Cimbalino.Toolkit.Services;
using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;

namespace App1.ViewModel
{
    public class MainViewModel : ViewModelBase
    {
        private string _name;

        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                Set(ref _name, value);
            }
        }

        public RelayCommand SayHelloCommand { get; private set; }

        public MainViewModel(IMessageBoxService messageBoxService)
        {
            SayHelloCommand = new RelayCommand(async () => await messageBoxService.ShowAsync("Hello " + Name + "!"));
        }
    }
}