﻿using System;
using System.Collections.Generic;
using System.Linq;
using Cimbalino.Phone.Toolkit.Extensions;

namespace PedroLamas.SmartWrapListDemo
{
    public class DataModel
    {
        private static IEnumerable<DataItem> _items;

        static DataModel()
        {
            var random = new Random();

            _items = Enumerable.Range(0, 400)
                .Select(x => new DataItem("item #{0}".FormatWithInvariantCulture(x), "Pictures/{0}.png".FormatWithInvariantCulture(random.Next(0, 10))));
        }

        public static IEnumerable<DataItem> GetItems()
        {
            return _items;
        }
    }
}