﻿using Cimbalino.Phone.Toolkit.Services;
using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;

namespace XamlNamescopeDemo.ViewModel
{
    public class MainViewModel: ViewModelBase
    {
        private readonly IMessageBoxService _messageBoxService;
        
        public RelayCommand<string> PageDoubleTapCommand { get; private set; }

        public MainViewModel(IMessageBoxService messageBoxService)
        {
            _messageBoxService = messageBoxService;
        
            PageDoubleTapCommand = new RelayCommand<string>(name =>
            {
                _messageBoxService.Show(string.Format("Hello \"{0}\"", 
                    name));
            });
        }
    }
}