﻿using System;
using System.Windows;
using System.Windows.Input;
using System.Windows.Interactivity;
using Microsoft.Phone.Controls;

namespace XamlNamescopeDemo
{
    public class PageDoubleTapBehavior : Behavior<FrameworkElement>
    {
        protected override void OnAttached()
        {
            base.OnAttached();

            AssociatedObject.LayoutUpdated += AssociatedObjectLayoutUpdated;
        }

        public ICommand Command
        {
            get { return (ICommand)GetValue(CommandProperty); }
            set { SetValue(CommandProperty, value); }
        }

        public static readonly DependencyProperty CommandProperty =
            DependencyProperty.Register("Command", typeof(ICommand), typeof(PageDoubleTapBehavior), null);

        public object CommandParameter
        {
            get { return GetValue(CommandParameterProperty); }
            set { SetValue(CommandParameterProperty, value); }
        }

        public static readonly DependencyProperty CommandParameterProperty =
            DependencyProperty.Register("CommandParameter", typeof(object), typeof(PageDoubleTapBehavior), null);

        private void AssociatedObjectLayoutUpdated(object sender, EventArgs e)
        {
            AssociatedObject.LayoutUpdated -= AssociatedObjectLayoutUpdated;

            var page = AssociatedObject as PhoneApplicationPage ?? AssociatedObject.Parent as PhoneApplicationPage;

            if (page == null)
            {
                throw new Exception("You can only associate to the Page or LayoutRoot of the Page");
            }

            page.DoubleTap += PageTap;

        }

        private void PageTap(object sender, System.Windows.Input.GestureEventArgs e)
        {
            Command.Execute(CommandParameter);
        }
    }
}