﻿using System;
using System.Linq;
using System.Windows;
using Microsoft.Phone.Controls;

namespace FrameBugSample
{
    public partial class MainPage : PhoneApplicationPage
    {
        private PhoneApplicationFrame _phoneApplicationFrame;

        public MainPage()
        {
            InitializeComponent();
        }

        private void PhoneApplicationPage_Loaded(object sender, RoutedEventArgs e)
        {
            _phoneApplicationFrame = (PhoneApplicationFrame)App.Current.RootVisual;

            Update();
        }

        private void NavigateButton_Click(object sender, RoutedEventArgs e)
        {
            NavigationService.Navigate(new Uri("/MainPage.xaml?" + DateTime.Now.ToString(), UriKind.Relative));
        }

        private void NavigationServiceRemoveBackEntryButton_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Success: " + (NavigationService.RemoveBackEntry() != null));

            Update();
        }

        private void PhoneApplicationFrameRemoveBackEntryButton_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Success: " + (_phoneApplicationFrame.RemoveBackEntry() != null));

            Update();
        }

        private void Update()
        {
            NavigationServiceBackStackCountTextBox.Text = NavigationService.BackStack.Count().ToString();
            NavigationServiceCanGoBackTextBox.Text = NavigationService.CanGoBack.ToString();
            PhoneApplicationFrameCanGoBackTextBox.Text = _phoneApplicationFrame.CanGoBack.ToString();
        }
    }
}